#include "TCPIPConfig.h"

#include "TCPIP Stack/TCPIP.h"
#include "TCPIP Stack/StackTsk.h"
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "lcd.h"
#include "node.h"
#include "dprs_symbol.h"
#include "crc.h"

#include <stdlib.h>
#include <ctype.h>

#include "GenericTypeDefs.h"
#include "HardwareProfile.h"
#include "usb_config.h"
#include "USB/usb.h"
#include "USB/usb_host_generic.h"
#include "../include/USB/timer.h"
#include "../USB/usb_host_local.h"
#include "MDD File System/FSIO.h"
#include "MDD File System/FSDefs.h"

// Defines how long to wait before assuming the query has failed
#define DPLUS_REPLY_TIMEOUT		(5ul*TICK_SECOND)

#define DPLUS_OPEN_TIMEOUT		(5ul*TICK_SECOND)

#define	MAX_RETRY_CONNECT_CALLSERVER	5

#define	MaxReConnectCnt	20
#define	MaxDprsReConnectCnt	30

// These are normally available network time servers.
// The actual IP returned from the pool will vary every
// minute so as to spread the load around stratum 1 timeservers.
// For best accuracy and network overhead you should locate the 
// pool server closest to your geography, but it will still work
// if you use the global pool.ntp.org address or choose the wrong 
// one or ship your embedded device to another geography.

void	DisplayIPValue(DWORD dwServerIP, char Text[]);
BOOL	CheckForNewAttach ( void );
void	usb_send_header (BYTE pkt[]);
void	usb_send_voice (BYTE pkt[]);
void	RF_CallsignPrint ( void );
void	send_dv_header(packet pkt);
void	send_dv_packet(packet pkt);
void	vTaskDelay( portTickType xTicksToDelay );
void	flushData(void);
void	MACWriteArray(BYTE address, BYTE *val, WORD wLen);
WORD	CalcIPChecksum(BYTE *AppConfig, WORD length);
void	KeepAliveSend( void );
static	void	add_connected_table (UDP_SOCKET sock, BYTE callsign[]);
static	void	delete_from_table (UDP_SOCKET sock);
static	void	SendSubClient (packet q_pkt);
static	void	SendFromSubClient(packet pkt, UDP_SOCKET socket);
void	ReLoadMsg(void);
void	InetHeaderLog(void);
void	GetRefDateTime(void);
static	void	CallDisplay (BYTE RFheader[]);
static	void	DprsData(BYTE SlowData[]);
static	BOOL	gps_sumcheck(BYTE string[]);
static	void	GPGLL (BYTE string[]);
static	void	GPGGA (BYTE string[]);
static	void	GPRMC (BYTE string[]);
static	void	RadioDprs_Send();
static	void	InetDprs_Send();
static	void	Radio_GPS_A_Send();
static	void	Inet_GPS_A_Send();
static	void	Inet_GPS_A(BYTE string[]);
static	void	dprs_message (BYTE string[]);
static	BOOL	GPS_A_SumCheck(BYTE string[]);
static	WORD	update_crc_dstar( WORD crc, BYTE c );
static	WORD	result_crc_dstar(WORD crc);
static	void	DprsProcess(void);
static	void	DprsBeacon_Send(void);
static	void	GetDprsMessage(void);
static	void	DprsMsgSend(BYTE Msg[]);
void	DprsSMTP(void);
static	void	DprsAck(BYTE SeqID[]);
static	void	AprsMsgSend(void);
static	void	RefSolved(void);


BYTE    deviceAddress;  // Address of the device on the USB

DWORD	KeepAliveTimer;

BYTE	RefName[8] = {"        "};
BYTE	RefNameSave[8];
BYTE	RefNameTemp[8];
BYTE	RefNameSet;
BYTE	CurServerName[20];
BYTE	MyCallSign[8];
static	BYTE	SlowData[6];
static	WORD	ServerPort = 20001;		/* default for DPlus */

BYTE	RefSkipSW;

static	BYTE	ReConnectCnt;
static	BYTE	ReDprsConnectCnt;
static	BYTE	ReDprsConnectCount;
static	BYTE	CallSockRetry;
static	BYTE	Text[35];

extern	BYTE	RoomName[8];
extern	BYTE	NodeName[8];
extern	WORD 	out_port;
extern	WORD 	in_port;

extern	WORD	seq;
extern	WORD	SSN;
extern	BYTE	PicVer[2];

extern	BYTE HeaderID[2];
extern	BYTE VoiceID[2];
extern	BYTE LastFrameID[2];
extern	BYTE CurUser[8];

static	char text[120];
extern	BYTE	DPRS_SW;
extern	struct DPRSinfo DPRS;
BYTE	AprsMsgTX[3];
BYTE	EmailAddress[48];
BOOL	AprsMessageSend = FALSE;
extern	BYTE	AprsDest[9];
extern	BYTE	AprsMessage[70];
extern	BYTE	AprsSenderCall[10];
extern	DWORD	AprsSeq;
extern	DWORD	RcvAprsSeq;

enum
	{
		DS_HOME = 0,
		DS_HOME_FIRST_TIME,
		DS_HOME_SECOND_TIME,
		DS_SOCKET_OBTAINED,
		DS_PROCESS_CONNECTED,
		DS_PROCESS_READY,
		DS_PROCESS_READ,
		DS_DPRS_OPEN,
		DS_DPRS_OPEN_AUTOLINK,
		DS_DPRS_OPEN_AUTORELINK,
		DS_DPRS_OPEN_DONE_AUTOLINK,
		DS_DPRS_OPEN_DONE_AUTORELINK,
		DS_DPRS_ACCEPT,
		DS_DPRS_ACCEPT_DONE,
		DS_WAIT_LINK_COMMAND,
		DS_WAIT_LINK,
		DS_UDP_OPEN_FIRST,
		DS_UDP_OPEN_SECOND,
		DS_UDP_OPEN,
		DS_UDP_IS_OPENED,
		DS_UDP_USB_DONE,
		DS_UDP_SEND,
		DS_UDP_RECV,
		DS_UDP_SEND_CALL,
		DS_UDP_RECV_OK,
		DS_UDP_SUB_SOCKET_OPEN,
		DS_LOOP
	} NodeDPlusState = DS_HOME;

enum
	{
		REFSOLVE_HOME = 0,
		REFSOLVE_NAME_RESOLVE,
		REFSOLVE_OBTAIN,
	} RefSolveState = REFSOLVE_HOME;

BYTE	RefDomainName[110];
extern	BOOL	ReqRefDomainName;

extern	xQueueHandle xDstarSndQueue;
extern	xQueueHandle xDstarRcvQueue;
extern	xQueueHandle xDstarRefQueue;
extern	xQueueHandle xDstarLogQueue;
extern	xQueueHandle xDstarDprsMsgQueue;
extern	xQueueHandle xDstarDprsEmailMsgQueue;

//extern	xTaskHandle TCPHandle;

struct	MessageSW 	Msg;

static	DWORD	Timer;
static	DWORD	DnsTimer;

static	BYTE	ReqConnect[5] = {0x05, 0x00, 0x18, 0x00, 0x01};
BYTE	ReqDisConnect[5] = {0x05, 0x00, 0x18, 0x00, 0x00};
static	BYTE	RecvTemp[8];
static	BYTE	AuthCallString[28] = {0x1c, 0xc0, 0x04, 0x00, 0x37, 0x4d, 0x33, 0x54,
									  0x4a, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
									  0x00, 0x00, 0x00, 0x00, 0x44, 0x56, 0x30, 0x31, 
									  0x39, 0x39, 0x39, 0x39};
static	BYTE	CallOK[8] = 	{0x08, 0xc0, 0x04, 0x00, 0x4f, 0x4b, 0x52, 0x57};
static	BYTE	CallRO[8] = 	{0x08, 0xc0, 0x04, 0x00, 0x4f, 0x4b, 0x52, 0x4f};
BYTE	Sync[3]	=		{0x03, 0x60, 0x00};
BYTE	PttOff[4] = 	{0x0a, 0xc0, 0x0b, 0x01};
static	BYTE	dplus_voice_hdr[] = {0x1d, 0x80, 0x44, 0x53, 0x56, 0x54, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x01, 0x02};
static	BYTE	dplus_header_hdr[] = {0x3a, 0x80, 0x44, 0x53, 0x56, 0x54, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00, 0x01, 0x02};
static	BYTE	DCS_ReqConnect[19] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	
										0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static	BYTE ReqCallList[56] = {0x38, 0xc0, 0x01, 0x00, 0x37, 0x4d, 0x33, 0x54, 0x4a, 0x5a,
								0x20, 0x20, 0x44, 0x56, 0x30, 0x31, 0x39, 0x39, 0x39, 0x39,
								0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x57, 0x58,
								0x49, 0x42, 0x32, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
								0x44, 0x48, 0x53, 0x30, 0x32, 0x35, 0x37, 0x20, 0x20, 0x20,
								0x20, 0x20, 0x20, 0x20, 0x20, 0x20 };

static	BYTE	*Buffer, *BuffPnt;
extern	BYTE	REF_IP_address[16];

UDP_SOCKET	ServerSocket = INVALID_UDP_SOCKET;
UDP_SOCKET	RcvDPlusSocket = INVALID_UDP_SOCKET;

struct	connected_table *first_pnt = NULL;
struct	connected_table *last_pnt = NULL;
struct	connected_table FirstTable;


extern	BYTE	TimeDate[20];
extern	BOOL	PTT_On;
extern	BOOL	COS_On;
static	BOOL	StillKeep = FALSE;
extern	BOOL	headerRead;
extern	BOOL	CallCheck_Skip;

static	packet	pkt;

struct	RefDateTime	RDateTime;
static	BOOL	ReloadSW = FALSE;
static	BYTE	IpCallList[26];

extern	BYTE	Inet_Callsign_Check_String[9];

static	BYTE DprsTemp[512];
static	BYTE i,k;

BYTE	InetLat[8], InetLong[9];
BYTE	InetCall[8];
BYTE	InetMsg[20];
BYTE	InetAtitude[6];
BYTE	InetSpeed[3];
BYTE	InetDirection[3];
BYTE	RadioLat[8], RadioLong[9];
BYTE	RadioCall[8];
BYTE	RadioMsg[20];
BYTE	RadioAtitude[6];
BYTE	RadioSpeed[3];
BYTE	RadioDirection[3];
BYTE	Radio_GPS_A_MSG[120];
BYTE	Inet_GPS_A_MSG[120];
BOOL	Radio_GPS_A_Msg_send;
BOOL	Inet_GPS_A_Msg_send;
BOOL	DprsOpen = FALSE;
static	DWORD	AprsInetTimer = 0;
static	DWORD	AprsRadioTimer = 0;
static	DWORD	DprsBeaconTimer = 0;
extern	BYTE	DprsMsgDstCallSign[10];
extern	BYTE	DprsMsgSrcCallSign[10];
extern	struct	AprsCallTable	*AprsCallTablePnt;
extern	BYTE	AprsCallTBLCnt;
extern	BOOL	ReqLoadAprsCallCheck;
BYTE	DprsMsgDstCallSignSave[9];

BOOL	RadioDprsSend, InetDprsSend;
extern	BOOL	ReqConvertLocalRefFile;
extern	BOOL	ReqRefDomainName;
extern	BYTE	RefDomainName[110];

extern	BOOL	DebugSW;

static	TCP_SOCKET	CallSocket = INVALID_SOCKET;
TCP_SOCKET	DprsSocket = INVALID_SOCKET;

struct DCS_Frame	DCS_recv;
	
void DstarDPlusClientUDP(void)
{
	static	packet	q_pkt;
	static	WORD	len, i, l;
	static	WORD	call_l;
	static	BOOL	RW_RO_sw;
	static	BYTE	RcvPacket_ID[2];
	static	struct	connected_table *pnt;
	static	WORD	TimeOutCnt;
	static	WORD	EntryCnt;
	static	WORD	Cnt, AcutualCnt;
	static	DWORD	rcv_packet_cnt;
	static	ROM BYTE hex[16] = {"0123456789ABCDEF"};
	static	BYTE	retry_cnt;
	static	WORD	UDPOpenTimeOutCnt;

	if (DprsOpen)
	{
		DprsProcess();
		if (!Msg.connectSW && !Msg.notfoundSW)
		{
			if (!PTT_On && !COS_On) DprsSMTP();
			if (AprsMessageSend) AprsMsgSend();
		}
		if (DPRS.Interval != 0)
		{
			if (DPRS.ClientID && ((TickGet() - DprsBeaconTimer) >= (DPRS.Interval * TICK_MINUTE / 2))) DprsBeacon_Send();
		}	
	}

	switch(NodeDPlusState)
	{
		case DS_LOOP:
			if (!PTT_On) StillKeep = FALSE;
			if (RefNameSet)
			{
				if (RefNameSet == 3)		/* ReLoad Gate/Ref list */
				{
					RefNameSet = 0;
					if (AppConfig.Flags.ircDDB) break;
					NodeDPlusState = DS_HOME;
					ReloadSW = TRUE;
					memcpy (RefNameTemp, RefName, 8);
					ReLoadMsg();
					break;
				}
				else if (RefNameSet == 2)	/* link */
				{
					if (UDPIsOpened(ServerSocket))
					{
						if (!AppConfig.Flags.ircDDB)			/* added 2012.07.20 */
						{
							while (UDPIsPutReady(ServerSocket) < 5)	StackTaskUDP();
							UDPPutArray((BYTE*)&ReqDisConnect, 5);
							UDPFlush();
							StackTaskUDP();
							UDPClose(RcvDPlusSocket);
							RcvDPlusSocket = INVALID_UDP_SOCKET;
							UDPClose(ServerSocket);
							ServerSocket = INVALID_UDP_SOCKET;
							StackTaskUDP();
						}
					}
					NodeDPlusState = DS_WAIT_LINK_COMMAND;
					memcpy (RefName, RefNameSave, 8);
					break;
				}
				else if (RefNameSet == 1)	/* disconnect (unlink) */
				{
					if (AppConfig.Flags.ircDDB) break;
					if (UDPIsOpened(ServerSocket))
					{
						while (UDPIsPutReady(ServerSocket) < 5) StackTaskUDP();
						UDPPutArray((BYTE*)&ReqDisConnect, 5);
						UDPFlush();
						StackTaskUDP();
						RefNameSet = 0;
						UDPClose(RcvDPlusSocket);
						UDPClose(ServerSocket);
						StackTaskUDP();
						NodeDPlusState = DS_WAIT_LINK;
						memcpy (Text, "Unlinked        ", 16);
						Text[16] = 0x00;
						xMessage.pcMessage = (char *)Text;
						xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
						xQueueSend( xLCDQueue, &xMessage, 0 );
						memset (RefName, 0x20, 8);
					}
					else
					{
						RefNameSet = 0;
						memcpy (Text, "Already Unlinked", 16);
						Text[16] = 0x00;
						xMessage.pcMessage = (char *)Text;
						xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
						xQueueSend( xLCDQueue, &xMessage, 0 );
					}	
					break;
				}
				else if (RefNameSet == 4)	/* APRS server connect(Link) */
				{
					RefNameSet = 0;
					ReDprsConnectCnt = 0;
					NodeDPlusState = DS_DPRS_OPEN_AUTOLINK;
					break;
				}
				else if (RefNameSet == 5)	/* APRS server disconnect (unlink) */
				{
					RefNameSet = 0;
					if (DprsSocket != INVALID_SOCKET)
					{
						TCPClose (DprsSocket);
						DprsSocket = INVALID_SOCKET;
					}
					memcpy (Text, "APRS Server     " "   Disconnected.", 32);
					xMessage.pcMessage = (char *)Text;
					xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
					xQueueSend( xLCDQueue, &xMessage, 0 );
					DprsOpen = FALSE;
					break;				
				}
				else if (RefNameSet == 6)	/* APRS server connect(AutoReLink) */
				{
					RefNameSet = 0;
					ReDprsConnectCnt = 0;
					ReDprsConnectCount = 0;
					NodeDPlusState = DS_DPRS_OPEN_AUTORELINK;
					break;
				}
			}

			/* from Inet (from DPlus) */
			if (UDPIsGetReady(ServerSocket))
			{
				if (!AppConfig.Flags.ircDDB)			/* added 2012.07.20 */
			 	{
					len = UDPGetArray((BYTE*)&pkt, 58);
					if (len == 3)
					{
						if (!memcmp((char *)&pkt, (char *)Sync, 3))
						{
							KeepAliveSend();
							TimeOutCnt = 0;
						}
					}
					else if (len == 5)	/* Req. Disconnect */
					{
						if (!memcmp((char *)&pkt, (char *)ReqDisConnect, 5))
						{
//							while (UDPIsPutReady(ServerSocket) < 5) StackTaskUDP();
//							UDPPutArray((BYTE*)&ReqDisConnect, 5);
//							UDPFlush();
							if (AppConfig.Flags.AutoReConnect)
							{
								NodeDPlusState = DS_UDP_SEND;
								ReConnectCnt++;
								if (ReConnectCnt > MaxReConnectCnt)
								{
									UDPClose(ServerSocket);
									RefNameSet = 0;
									memset (RefName, 0x20, 8);
									NodeDPlusState = DS_WAIT_LINK_COMMAND;
								}
							}
							else
							{
								UDPClose(ServerSocket);
								RefNameSet = 0;
								memset (RefName, 0x20, 8);
								NodeDPlusState = DS_WAIT_LINK_COMMAND;
							}
						}
					}
					if (!Msg.connectSW && !Msg.notfoundSW)			/* check the still voice message sending? */
					{
						if (len == 58)		/* header packet */
						{
							memcpy (MyCallSign, &pkt.header[27], 8);

							if ((pkt.header[26] != 'U') && (pkt.header[26] != 'L'))
							{  
								if (RefName[7] == '*')		/* * */
								{
									if (memcmp (RcvPacket_ID, &pkt.B_header.PacketID, 2))
									{
										memcpy (RcvPacket_ID, &pkt.B_header.PacketID, 2);
										xQueueSend (xDstarRcvQueue, &pkt, 0);
										InetHeaderLog();
										CallDisplay ((BYTE *)&pkt.header);	
									}
									LED1_IO ^= 1;
								}
								else if (!memcmp(&pkt.header[3], RefName, 8) 
											|| !memcmp(&pkt.header[11], RefName, 8))
								{
									if (!StillKeep && !headerRead)
									{
										if (!memcmp (RcvPacket_ID, &pkt.B_header.PacketID, 2))
										{
											if (DebugSW)
											{
												sprintf (text, "%19.19s From Inet Received Extra Header.  Mycall: %8.8s YourCall: %8.8s ID:%2.2x%2.2x\r\n",
													TimeDate, &pkt.header[27], &pkt.header[19],pkt.B_header.PacketID[0],pkt.B_header.PacketID[1]);
												xQueueSend( xDstarLogQueue, &text, 0 );
											}
										}
										else 
										{
											CallDisplay ((BYTE *)&pkt.header);	
											xQueueSend (xDstarRcvQueue, &pkt, 0);
											StillKeep = TRUE;
											LED1_IO ^= 1;
											InetHeaderLog();
											memcpy (RcvPacket_ID, &pkt.B_header.PacketID, 2);
											rcv_packet_cnt = 0;
										}
									}
									else
									{
										memcpy (&Text[0],&pkt.header[27], 8);
										Text[14] = hex[pkt.header[0]>>4];
										Text[15] = hex[pkt.header[0] & 0x0f];
										memcpy (&Text[16],&pkt.header[19], 8);
										if (memcmp (&pkt.header[35],"    ",4))
										{
											Text[8] = '/';
											memcpy (&Text[9],&pkt.header[35], 4);
										}
										xMessage.pcMessage = (char *)&Text;
										xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
										if (!memcmp (RcvPacket_ID, &pkt.B_header.PacketID, 2))
										{
												memcpy (&Text[24], " SAME ID", 8);
												sprintf (text, "%19.19s From Inet Received Same Packet ID.  Mycall: %8.8s YourCall: %8.8s ID:%2.2x%2.2x\r\n",
													TimeDate, &pkt.header[27], &pkt.header[19],pkt.B_header.PacketID[0],pkt.B_header.PacketID[1]);
										}
										else
										{
											memcpy (&Text[24], " CALLING", 8);
											sprintf (text, "%19.19s From Inet Received Double calling. Mycall: %8.8s YourCall: %8.8s ID:%2.2x%2.2x\r\n",
												TimeDate, &pkt.header[27], &pkt.header[19],pkt.B_header.PacketID[0],pkt.B_header.PacketID[1]);
										}	
										xQueueSend( xDstarLogQueue, &text, 0 );
										for (i = 0 ; i < 32 ; i++)
										{
												if (Text[i] == 0x00) Text[i] = 0x20;
										}
										xQueueSend( xLCDQueue, &xMessage, 0 );
									}	
								}
							}
						}			/* voice packet */
						else if (((RefName[7] != '*') && (!memcmp(RcvPacket_ID, &pkt.B_header.PacketID, 2))) || (RefName[7] == '*'))
						{
							if ((len == 29) || (len == 32))
							{
								xQueueSend (xDstarRcvQueue, &pkt, 0);
								LED1_IO ^= 1;
								rcv_packet_cnt++;
								if (DPRS.InetSW && DPRS.DprsSW)
								{
									if (pkt.B_header.seq != 0)
									{
										if (pkt.B_header.seq % 2)
										{
											memcpy (SlowData, &pkt.voice[9], 3);
											SlowData[0] ^= 0x70;
											SlowData[1] ^= 0x4f;
											SlowData[2] ^= 0x93;
										} else {
											memcpy (&SlowData[3], &pkt.voice[9], 3);
											SlowData[3] ^= 0x70;
											SlowData[4] ^= 0x4f;
											SlowData[5] ^= 0x93;
											if ((SlowData[0] & 0xf0) == 0x30) DprsData(SlowData); 
										}
									}
								}
								if (len == 32)
								{
									StillKeep = FALSE;
								}
							}
							else if (len == 10)
							{
								if (!memcmp((char *)&pkt, (char *)PttOff, 4))
								{
									KeepAliveSend();
									xQueueSend (xDstarRcvQueue, &pkt, 50 / portTICK_RATE_MS);
									sprintf (text, "%19.19s From Inet Received packets : %ld\r\n",TimeDate, rcv_packet_cnt);
									xQueueSend( xDstarLogQueue, &text, 0 );
									memset ((char *)RcvPacket_ID, 0x00, 2);
									StillKeep = FALSE;
									rcv_packet_cnt = 0;
								}
							}
						}
					}
					SendSubClient(pkt);
			   	}
				else if (AppConfig.ircDDBtype == 1)
				{
					len = UDPGetArray((BYTE *)&DCS_recv, 100);
					if (len == 100)		/* DCS Frame read */
					{
						if (DCS_recv.FrameSeq == 0x00) /* header send */ 
						{
							memcpy (&pkt, dplus_header_hdr, 14);
							memcpy (&pkt.B_header.PacketID, DCS_recv.StreamID, 2);
							pkt.B_header.seq = 0x80;
							memcpy (&pkt.header, &DCS_recv.flags, 39);
							memset (&pkt.header[39], 0x00, 2);
							xQueueSend (xDstarRcvQueue, &pkt, 0);
						}
						memcpy (&pkt, dplus_voice_hdr, 14);
						memcpy (&pkt.B_header.PacketID, &DCS_recv.StreamID, 15);
						xQueueSend (xDstarRcvQueue, &pkt, 0);
					}
					if (len == 15)		/* DCS disconnect */
					{
					}
					if (len == 14)		/* DCS disconnect */
					{
					}
					
				}
			}
	
			/* check the time out of Keep alive */
			if (!AppConfig.Flags.ircDDB)			/* added 2012.07.20 */
			{
				if ((TickGet() - KeepAliveTimer) > TICK_SECOND)		/* 2 sec. */
				{
					KeepAliveSend();
					TimeOutCnt++;
				}
				if (TimeOutCnt >= 20)			/* wait 40 sec. */
				{	
					memcpy (Text, "Link Lost       ", 16);
					memcpy ((char *)&Text[16], (char *)RefName, 8);
					Text[24] = 0x00;
					xMessage.pcMessage = (char *)Text;
					xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
					xQueueSend( xLCDQueue, &xMessage, 0 );
					sprintf (text, "%19.19s Link Lost.\r\n",TimeDate);
					xQueueSend( xDstarLogQueue, &text, 0 );
					NodeDPlusState = DS_WAIT_LINK_COMMAND;
					UDPClose(RcvDPlusSocket);
					UDPClose(ServerSocket);
					memset (RefName, 0x20, 8);
					if (AppConfig.Flags.AutoReConnect && !ReloadSW)
					{
						RefNameSet = 2;
						sprintf (text, "%19.19s Auto. ReConnection Start (%8.8s).\r\n",TimeDate,RefNameSave);
						xQueueSend( xDstarLogQueue, &text, 0 );
						break;
					}
				}
			}

			/* receive the connect and auth. packet */
			if (UDPIsGetReady(RcvDPlusSocket))
			{
				len = UDPGetArray((BYTE*)&pkt, 58);
				if ((len == 5) && !memcmp(&pkt, ReqConnect, 5))
				{
					while (UDPIsPutReady(RcvDPlusSocket) < 5) StackTaskUDP();
					UDPPutArray((BYTE*)&ReqConnect, 5);
					UDPFlush();
				}
				else if ((len == 28) && !memcmp(&pkt, AuthCallString, 4))
				{
					while (UDPIsPutReady(RcvDPlusSocket) < 8) StackTaskUDP();
					memcpy (Inet_Callsign_Check_String, &AuthCallString[4], 8);
					if (!CallCheck_Skip)
					{
						Inet_Callsign_Check_String[8] = 'S';
						while (Inet_Callsign_Check_String[8] == 'S') vTaskDelay(5 / portTICK_RATE_MS);
						if (Inet_Callsign_Check_String[8] == 'F') UDPPutArray((BYTE*)&CallOK, 8);
						else									 UDPPutArray((BYTE*)&CallRO, 8);
						UDPFlush();
						add_connected_table (RcvDPlusSocket, &AuthCallString[4]);
						RcvDPlusSocket = UDPOpenEx((DWORD)NULL,UDP_OPEN_SERVER,ServerPort,0);
					}
				}
			}

			/* send sub client */
loop:
			pnt = first_pnt->f_chain;
			while (pnt)
			{
				if (UDPIsOpened (pnt->SendSocket) == TRUE)
				{
					if (UDPIsGetReady(pnt->SendSocket))
					{
						len = UDPGetArray((BYTE*)&pkt, 58);
						if (len == 3)
						{
							if (!memcmp((char *)&pkt, (char *)Sync, 3))
							{
								while (UDPIsPutReady(pnt->SendSocket) < 3) StackTaskUDP();
								UDPPutArray((BYTE*)Sync, 3);
								UDPFlush();
								pnt->timeout = TickGet();
							}
						} 
						else if (len == 5)
						{
							if (!memcmp((char *)&pkt, (char *)ReqDisConnect, 5))
							{
								while (UDPIsPutReady(pnt->SendSocket) < 5) StackTaskUDP();
								UDPPutArray((BYTE*)&ReqDisConnect, 5);
								UDPFlush();
								delete_from_table(pnt->SendSocket);
							}
						} 
						else
						{
							SendFromSubClient (pkt, pnt->SendSocket);
						}
					}
				}
				if ((TickGet() - pnt->timeout) > 30*TICK_SECOND)
				{
					delete_from_table (pnt->SendSocket);
					goto loop;
				}
				pnt = pnt->f_chain;
			}

			/***** From Rig *****/
			if (xQueueReceive(xDstarSndQueue, &q_pkt, 0) == pdTRUE)
			{
				if ((RW_RO_sw) && (RefName[7] != '*'))		/* DPlus Read Write */
				{
					if (!memcmp((char *)q_pkt.DPlusID, (char *)VoiceID, 2))
					{
						while (UDPIsPutReady(ServerSocket) < 29) StackTaskUDP();
						UDPPutArray((BYTE*) &q_pkt, 29);
					}
					else if (!memcmp((char *)q_pkt.DPlusID, (char *)HeaderID, 2))
					{
						while (UDPIsPutReady(ServerSocket) < 58) StackTaskUDP();
						UDPPutArray((BYTE*) &q_pkt, 58);
					}
					else if (!memcmp((char *)q_pkt.DPlusID, (char *)LastFrameID, 2))
					{
						while (UDPIsPutReady(ServerSocket) < 32) StackTaskUDP();
						memset (&q_pkt.lastframe[3], 0x55, 9);
						q_pkt.lastframe[12] = 0x25;
						q_pkt.lastframe[13] = 0x1a;
						q_pkt.lastframe[14] = 0xc6;
						UDPPutArray((BYTE*) &q_pkt, 32);
					}
					else if (!memcmp((char *)q_pkt.DPlusID, (char *)PttOff, 2))
					{
						while (UDPIsPutReady(ServerSocket) < 10) StackTaskUDP();
						UDPPutArray((BYTE*) &q_pkt, 10);	
					}
					UDPFlush();
					LED1_IO ^= 1;
					StackTaskUDP();
					SendSubClient(q_pkt);
				}
			}
			break;

		/* ******************** start here  ******************* */
		case DS_HOME:
			DPRS_SW = 1;	/* DPRS read the seting information */
			first_pnt = &FirstTable;
			first_pnt->f_chain = NULL;
			first_pnt->SendSocket = INVALID_UDP_SOCKET;
			last_pnt = first_pnt;
			RefNameSet = 0;
			ReConnectCnt = 0;
			ReDprsConnectCnt = 0;
			ReDprsConnectCount = 0;
			CallSockRetry = 0;
			memset (RefName, 0x20, 8);
			memset (RefNameSave, 0x20, 8);
			while (DPRS_SW) vTaskDelay(50 / portTICK_RATE_MS);

			if (AppConfig.Flags.ircDDB)			/* added 2012.07.20 */
			{
					NodeDPlusState = DS_DPRS_OPEN;
					break;
			}
			
			if (CallSocket == INVALID_SOCKET)
			{
				CallSocket = TCPOpen((DWORD)(PTR_BASE)"opendstar.org", TCP_OPEN_ROM_HOST, 20001, TCP_PURPOSE_GATELIST_TCP_CLIENT);
				if(CallSocket == INVALID_SOCKET) break;
			}
			retry_cnt = 0;
			Timer = TickGet();
			NodeDPlusState = DS_HOME_FIRST_TIME;
			if (AppConfig.Flags.AutoConnect && !ReloadSW)
			{
				memcpy (RefNameSave, AppConfig.DefaultRefName, 8);
				RefNameSet = 2;
				memcpy (CurServerName, AppConfig.ServerName, 16);
			}
			ReqConvertLocalRefFile = TRUE;
			break;

		case DS_HOME_FIRST_TIME:
			if (ReqRefDomainName) RefSolved();
			if (!ReqConvertLocalRefFile) NodeDPlusState = DS_SOCKET_OBTAINED;
			break;

		case DS_HOME_SECOND_TIME:
			if (CallSocket == INVALID_SOCKET)
			{
				CallSocket = TCPOpen((DWORD)(PTR_BASE)"opendstar.org", TCP_OPEN_ROM_HOST, 20001, TCP_PURPOSE_GATELIST_TCP_CLIENT);
				if(CallSocket == INVALID_SOCKET) break;
			}
			NodeDPlusState = DS_SOCKET_OBTAINED;
			break;

		case DS_SOCKET_OBTAINED:
			// Wait for the remote server to accept our connection request
			if(!TCPIsConnected(CallSocket))
			{
				// Time out if too much time is spent in this state
				if((TickGet()-Timer) > 3*TICK_SECOND)		/* wait 6 seconds */
				{
					CallSockRetry++;
					if (CallSockRetry < 5)
					{
						TCPDisconnect(CallSocket);
						TCPDisconnect(CallSocket);
						TCPClose (CallSocket);
						CallSocket = INVALID_SOCKET;
						NodeDPlusState = DS_HOME_SECOND_TIME;
						break;
					}
					// Close the socket so it can be used by other modules
					TCPDisconnect(CallSocket);
					TCPClose (CallSocket);
					CallSocket = INVALID_SOCKET;
					sprintf (text, "%19.19s Did not read the gateweay list. Skip read the list.\r\n", TimeDate);
					xQueueSend( xDstarLogQueue, &text, 0 );
					memcpy (Text, "Wait  (G/R Skip)" "   Link Command.", 32);
					xMessage.pcMessage = (char *)Text;
					xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
					xQueueSend( xLCDQueue, &xMessage, 0 );
					
					RefSkipSW = 'F';
					while (RefSkipSW == 'F') vTaskDelay(10 / portTICK_RATE_MS);
					if (RefSkipSW == 'S') NodeDPlusState = DS_DPRS_OPEN;
					else
					{
						sprintf (text, "%19.19s Did not find the Gateweay/Reflector file .\r\n", TimeDate);
						xQueueSend( xDstarLogQueue, &text, 0 );
						memcpy (Text, "Did not find    " "  Gate/Ref file.", 32);
						xMessage.pcMessage = (char *)Text;
						xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
						xQueueSend( xLCDQueue, &xMessage, 0 );
						for ( ; ; );
					}
				}
				break;
			}
			sprintf (text, "%19.19s Connect to opendstar.org (gateway/reflector list server).\r\n",TimeDate);
			xQueueSend( xDstarLogQueue, &text, 0 );
			NodeDPlusState = DS_PROCESS_CONNECTED;
			break;

		case DS_PROCESS_CONNECTED:
			// Make certain the socket can be written to
			if(TCPIsPutReady(CallSocket) < 60u)
				break;

			memset (&ReqCallList[4], 0x20, 8);
			l = strlen((char *)AppConfig.DefaultAuthCall);
			if (l > 8) l = 8;
			memcpy (&ReqCallList[4], AppConfig.DefaultAuthCall, l);
			TCPPutArray (CallSocket, ReqCallList, 56);
			TCPFlush (CallSocket);
			NodeDPlusState = DS_PROCESS_READY;
			Timer = TickGet();
			break;

		case DS_PROCESS_READY:
			// Get count of RX bytes waiting
			if (!TCPIsGetReady(CallSocket))
			{
				if ((TickGet() - Timer) > 5*TICK_SECOND)	/* wait 30 seconds */
				{
					retry_cnt++;
					if (retry_cnt > MAX_RETRY_CONNECT_CALLSERVER)
					{
						NodeDPlusState = DS_UDP_OPEN_FIRST;
						TCPDisconnect(CallSocket);
						TCPClose (CallSocket);
						CallSocket = INVALID_SOCKET;
						vTaskDelay(500 / portTICK_RATE_MS);
					}
					else
					{
						TCPDisconnect(CallSocket);
						TCPDisconnect(CallSocket);
						TCPClose (CallSocket);
						CallSocket = INVALID_SOCKET;
						NodeDPlusState = DS_HOME_SECOND_TIME;
					}
				}
				break;
			}	
			NodeDPlusState = DS_PROCESS_READ;
			call_l = 0;
			Timer = TickGet();
			memcpy (Text, "Gate List Read  " "           Start", 32);
			xMessage.pcMessage = (char *)Text;
			xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
			xQueueSend( xLCDQueue, &xMessage, 0 );
			Buffer = pvPortMalloc (502);
			Cnt = 0;
			AcutualCnt = 0;
			xQueueSend (xDstarRefQueue, "O", portMAX_DELAY);  /* Gate/Ref file open */
			break;

		case DS_PROCESS_READ:			/* gateway list read */
			if (!TCPIsGetReady(CallSocket)) 
			{
				if((TickGet()-Timer) > 5*TICK_SECOND)	/* wait 10 seconds */
				{
					xQueueSend (xDstarRefQueue, "P", portMAX_DELAY);
		
					TCPDisconnect(CallSocket);
					TCPClose (CallSocket);
					CallSocket = INVALID_SOCKET;
					memcpy (Text, "Gate List Read  " "    Partial Read", 32);
					xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
					xQueueSend( xLCDQueue, &xMessage, 0 );
					vPortFree(Buffer);
					NodeDPlusState = DS_DPRS_OPEN;
					Timer = TickGet();
				}
				break;
			}
			else 
			{
				len = TCPGetArray(CallSocket, Buffer, 502);
				BuffPnt = Buffer;
				Timer = TickGet();
				for (i = 0 ; i < len ; i++)
				{
					if (call_l == 0)
					{
						if ((*BuffPnt >= 0x3a) || ((*BuffPnt >= 0x01) && (*BuffPnt <= 0x2a)))		/* BuffPnt > '9' */
						{
							EntryCnt = *(BuffPnt+6) + *(BuffPnt+7) * 256;
							BuffPnt += 8;
							i += 8;
						}
					}
					IpCallList[call_l] = *BuffPnt;
					BuffPnt++;
					call_l++;
					if (call_l > 25)
					{
						if ((IpCallList[25] == 0x80) && strlen((char *)IpCallList))
						{
							xQueueSend (xDstarRefQueue, IpCallList, portMAX_DELAY);
							AcutualCnt++;
						}
						call_l = 0;
						Cnt++;
						if (Cnt == EntryCnt)				/* read complete */
						{
							xQueueSend (xDstarRefQueue, "C", portMAX_DELAY);
							TCPDisconnect(CallSocket);
							TCPClose (CallSocket);
							CallSocket = INVALID_SOCKET;
							vPortFree(Buffer);
							if (!ReloadSW) memcpy (RefName, RefNameSave, 8);
							else 		memcpy (RefName, RefNameTemp, 8);
							sprintf (text, "%19.19s Gateway list read Done. %4d/%04d/%04d\r\n",TimeDate, AcutualCnt, Cnt, EntryCnt);
							xQueueSend( xDstarLogQueue, &text, 0 );
							sprintf ((char *)Text, "Gate List Read    %4d/%04d/%04d", AcutualCnt,Cnt, EntryCnt);
							xMessage.pcMessage = (char *)Text;
							xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
							xQueueSend( xLCDQueue, &xMessage, 0 );
							NodeDPlusState = DS_DPRS_OPEN;
							Timer = TickGet();
							break;
						}
					}
				}
			}
			break;

		case DS_DPRS_OPEN:
			if (DprsOpen)
			{
				NodeDPlusState = DS_WAIT_LINK_COMMAND;
				break;
			}
			ReDprsConnectCnt = 0;
			if (DPRS.AutoLink)	NodeDPlusState = DS_DPRS_OPEN_AUTOLINK;
			else 				NodeDPlusState = DS_WAIT_LINK_COMMAND;
			break;

		case DS_DPRS_OPEN_AUTOLINK:

			if (DPRS.DprsSW && (DPRS.RadioSW || DPRS.InetSW))
			{
				if(DprsSocket == INVALID_SOCKET)
				{
					DprsSocket = TCPOpen((DWORD)(PTR_BASE)DPRS.IPaddress, TCP_OPEN_ROM_HOST, DPRS.Port, TCP_PURPOSE_APRS_TCP_CLIENT);
					if (DprsSocket == INVALID_SOCKET)
					{
						if((TickGet()-Timer) > 5*TICK_SECOND)	/* wait 10 seconds */
						{
							ReDprsConnectCnt++;
							if (ReDprsConnectCnt > 5)
							{
								NodeDPlusState = DS_WAIT_LINK_COMMAND;
								TCPDisconnect(DprsSocket);
								TCPClose (DprsSocket);
								DprsSocket = INVALID_SOCKET;
								ReDprsConnectCnt = 0;
								break;
							}
							Timer = TickGet();
						}
					}
					else
					{
						NodeDPlusState = DS_DPRS_OPEN_DONE_AUTOLINK;
						sprintf (text, "%19.19s Connect to APRS Server.\r\n",TimeDate);
						xQueueSend( xDstarLogQueue, &text, 0 );
						Timer = TickGet();
					}
					break;
				}
			}
			NodeDPlusState = DS_WAIT_LINK_COMMAND;
			break;


		case DS_DPRS_OPEN_AUTORELINK:

			if (DPRS.DprsSW && (DPRS.RadioSW || DPRS.InetSW))
			{
				if(DprsSocket == INVALID_SOCKET)
				{
					DprsSocket = TCPOpen((DWORD)(PTR_BASE)DPRS.IPaddress, TCP_OPEN_ROM_HOST, DPRS.Port, TCP_PURPOSE_APRS_TCP_CLIENT);
					if (DprsSocket == INVALID_SOCKET)
					{
						if((TickGet()-Timer) > 15*TICK_SECOND)	/* wait 30 seconds */
						{
							ReDprsConnectCnt++;
							if (ReDprsConnectCnt > MaxDprsReConnectCnt)
							{
								NodeDPlusState = DS_WAIT_LINK_COMMAND;
								TCPDisconnect(DprsSocket);
								TCPClose (DprsSocket);
								DprsSocket = INVALID_SOCKET;
								ReDprsConnectCnt = 0;
								break;
							}
							Timer = TickGet();
						}
					}
					else
					{
						NodeDPlusState = DS_DPRS_OPEN_DONE_AUTORELINK;
						sprintf (text, "%19.19s Connect to APRS Server.\r\n",TimeDate);
						xQueueSend( xDstarLogQueue, &text, 0 );
						Timer = TickGet();
					}
					break;
				}
			}
			NodeDPlusState = DS_WAIT_LINK_COMMAND;
			break;

		case DS_DPRS_OPEN_DONE_AUTOLINK:
			if (TCPIsGetReady(DprsSocket)) 
			{
				len = TCPGetArray(DprsSocket, (BYTE *)DprsTemp, 50);
				if ((len > 2) && !memcmp(DprsTemp, "# ", 2))
				{
					NodeDPlusState = DS_DPRS_ACCEPT;
					sprintf (text, "%19.19s Connected to APRS Server.\r\n",TimeDate);
					xQueueSend( xDstarLogQueue, &text, 0 );
					break;
				}
			}
			if((TickGet()-Timer) > 2*TICK_SECOND)	/* wait 4 seconds */
			{
				ReDprsConnectCnt++;
				if (ReDprsConnectCnt > 5)
				{
					NodeDPlusState = DS_WAIT_LINK_COMMAND;
					TCPDisconnect(DprsSocket);
					TCPClose (DprsSocket);
					DprsSocket = INVALID_SOCKET;
					ReDprsConnectCnt = 0;
					break;
				}
				Timer = TickGet();
			}
			break;

		case DS_DPRS_OPEN_DONE_AUTORELINK:
			if (TCPIsGetReady(DprsSocket)) 
			{
				len = TCPGetArray(DprsSocket, (BYTE *)DprsTemp, 50);
				if ((len > 2) && !memcmp(DprsTemp, "# ", 2))
				{
					NodeDPlusState = DS_DPRS_ACCEPT;
					sprintf (text, "%19.19s Connected to APRS Server.\r\n",TimeDate);
					xQueueSend( xDstarLogQueue, &text, 0 );
					break;
				}
			}
			if((TickGet()-Timer) > 2*TICK_SECOND)	/* wait 4 seconds */
			{
				ReDprsConnectCnt++;
				if (ReDprsConnectCnt > 5)
				{
					TCPDisconnect(DprsSocket);
					TCPClose (DprsSocket);
					DprsSocket = INVALID_SOCKET;
					ReDprsConnectCnt = 0;
					ReDprsConnectCount++;
					if (ReDprsConnectCount > 30)
					{
						sprintf (text, "%19.19s Did not connect to APRS Server.\r\n",TimeDate);
						NodeDPlusState = DS_WAIT_LINK_COMMAND;
					}
					else
					{
						sprintf (text, "%19.19s Retry the reconnecting to APRS Server.\r\n",TimeDate);
						NodeDPlusState = DS_DPRS_OPEN_AUTORELINK;
					}
					xQueueSend( xDstarLogQueue, &text, 0 );
					break;
				}
				Timer = TickGet();
			}
			break;

		case DS_DPRS_ACCEPT:
			if (TCPIsPutReady(DprsSocket) > 60)
			{
				TCPPutArray (DprsSocket, (BYTE *)"user ", 5);
				k = 0;
				for (i = 0 ; i < 8 ; i++)
				{
					if (DPRS.CallSign[i] != 0x20)
					{
						DprsTemp[k] = DPRS.CallSign[i];
						k++;
					}
					else
					{
						if (k > 0)
						{
							if(DprsTemp[k-1] != '-')
							{
								DprsTemp[k] = '-';
								k++;
							}
						}
					}
				}
				TCPPutArray (DprsSocket, DprsTemp , k);
				TCPPutArray (DprsSocket, (BYTE *)" pass " , 6);
				for (i = 0 ; i < 8 ; i++)
				{
					if ((DPRS.ValidCode[i] < 0x30) || (DPRS.ValidCode[i] > 0x39)) break;
				} 
				TCPPutArray (DprsSocket, DPRS.ValidCode , i);
				TCPPutArray (DprsSocket, (BYTE *)" vers SAAP 00.32B\r\n" , 19);
				NodeDPlusState = DS_DPRS_ACCEPT_DONE;
				sprintf (text, "%19.19s Send ID & Validation Code to APRS Server.\r\n",TimeDate);
				xQueueSend( xDstarLogQueue, &text, 0 );
				ReDprsConnectCnt = 0;
			}
			break;

		case DS_DPRS_ACCEPT_DONE:
			if (TCPIsGetReady(DprsSocket)) 
			{
				len = TCPGetArray(DprsSocket, (BYTE *)DprsTemp, 200);
				if (len > 80) len = 80;
				DprsTemp[len] = 0x00;
				sprintf (text, "%19.19s %s\r\n",TimeDate, DprsTemp);

				xQueueSend( xDstarLogQueue, &DprsTemp, 0 );
				if ((len > 10) && !memcmp(DprsTemp, "# logresp ", 10))
				{
					i = 10;
					while (DprsTemp[i] != ' ') i++;
					if (!memcmp (&DprsTemp[i+1], "verified",8))
					{
						sprintf (text, "%19.19s Accepted the ID & Validation code from APRS Server.\r\n",TimeDate);
						xQueueSend( xDstarLogQueue, &text, 0 );
						DprsOpen = TRUE;
						RadioDprsSend = FALSE;
						InetDprsSend = FALSE;
						Radio_GPS_A_Msg_send = FALSE;
						Inet_GPS_A_Msg_send = FALSE;
						memset (RadioDirection, 0x00, 3);
						memset (RadioSpeed, 0x00, 3);
						memset (RadioAtitude, 0x00, 6);
						memset (InetDirection, 0x00, 3);
						memset (InetSpeed, 0x00, 3);
						memset (InetAtitude, 0x00, 6);
						memcpy (Text, "APRS Server     " "        Verified", 32);
						xMessage.pcMessage = (char *)Text;
						xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
						xQueueSend( xLCDQueue, &xMessage, 0 );
						memset (DprsMsgDstCallSignSave, 0x20, 9);
						ReqLoadAprsCallCheck = TRUE;	
						if (DPRS.ClientID) DprsBeacon_Send();
					} else {
						sprintf (text, "%19.19s Did not accept the ID & Validation code from APRS Server.\r\n",TimeDate);
						xQueueSend( xDstarLogQueue, &text, 0 );
						DprsOpen = FALSE;
						TCPClose (DprsSocket);
						DprsSocket = INVALID_SOCKET;
						memcpy (Text, "APRS Server     " "      Unverified", 32);
						xMessage.pcMessage = (char *)Text;
						xMessage.xMinDisplayTime = 3000 /  portTICK_RATE_MS;
						xQueueSend( xLCDQueue, &xMessage, 0 );
					}
					NodeDPlusState = DS_WAIT_LINK_COMMAND;
					break;
				}
			}
			if((TickGet()-Timer) > 5*TICK_SECOND)	/* wait 10 seconds */
			{
				NodeDPlusState = DS_WAIT_LINK_COMMAND;
				TCPDisconnect(DprsSocket);
				TCPClose (DprsSocket);
				DprsSocket = INVALID_SOCKET;
			}
			break;

		case DS_WAIT_LINK_COMMAND:
			if (UDPIsOpened(ServerSocket))
			{
				NodeDPlusState = DS_UDP_SUB_SOCKET_OPEN;
				break;
			}

			if (!AppConfig.Flags.AutoConnect)
			{
				memcpy (Text, "Wait            " "    Link Command", 32);
				xMessage.pcMessage = (char *)Text;
				xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
				xQueueSend( xLCDQueue, &xMessage, 0 );
				sprintf (text, "%19.19s Wait Link Command.\r\n",TimeDate);
				xQueueSend( xDstarLogQueue, &text, 0 );
			}
			NodeDPlusState = DS_WAIT_LINK;
			UDPOpenTimeOutCnt = 0;
			break;
		
		case DS_WAIT_LINK:
			if (ReloadSW)
			{
				ReloadSW = FALSE;
				NodeDPlusState = DS_LOOP;
				break;
			}

			if (RefNameSet == 2)
			{
				NodeDPlusState = DS_UDP_OPEN_FIRST;
				memcpy (RefName, RefNameSave, 8);
				RefNameSet = 0;
			}
			else if (RefNameSet == 3)
			{
				RefNameSet = 0;
				NodeDPlusState = DS_HOME;
				ReLoadMsg();
			}
			else if (RefNameSet == 4)	/* APRS server connect(Link) */
			{
				RefNameSet = 0;
				NodeDPlusState = DS_DPRS_OPEN_AUTOLINK;
			}
			else if (RefNameSet == 5)	/* APRS server disconnect (unlink) */
			{
				RefNameSet = 0;
				if (DprsSocket != INVALID_SOCKET)
				{
					TCPClose (DprsSocket);
					DprsSocket = INVALID_SOCKET;
				}
				DprsOpen = FALSE;
			}
			else if (RefNameSet == 6)	/* APRS server connect(Link) */
			{
				RefNameSet = 0;
				NodeDPlusState = DS_DPRS_OPEN_AUTORELINK;
			}
			if (DPRS.Interval != 0)
			{
				if (DprsOpen && DPRS.ClientID && ((TickGet() - DprsBeaconTimer) >= (DPRS.Interval * TICK_MINUTE / 2))) DprsBeacon_Send();
			}
			break;

		case DS_UDP_OPEN_FIRST:
			if (!AppConfig.Flags.ircDDB)
			{
				NodeDPlusState = DS_UDP_OPEN;
				break;
			}				

			memset (RefDomainName, 0x00, 32);
			memcpy (RefDomainName, RefName, 7);
			RefDomainName[7] = 0x20;
			for (i = 0 ; i < 8 ; i++)
			{
				if (RefDomainName[i] == 0x20) break;
			}
			if (AppConfig.ircDDBtype == 0)
			{
					memcpy (&RefDomainName[i], ".reflector.ircddb.net", 21);					
			}
			else if (AppConfig.ircDDBtype == 1)
			{
					memcpy (&RefDomainName[i], ".dcs.ircddb.net", 15);					
			}
			else if (AppConfig.ircDDBtype == 2)
			{
					memcpy (&RefDomainName[i], ".dxtra.ircddb.net", 17);					
			}
			ReqRefDomainName = TRUE;
			NodeDPlusState = DS_UDP_OPEN_SECOND;
			break;

		case DS_UDP_OPEN_SECOND:
			RefSolved();
			if (ReqRefDomainName) break;
			if (memcmp (RefDomainName, "0.0.0.0", 7))
			{
				memcpy (CurServerName, RefDomainName, 16);
				NodeDPlusState = DS_UDP_OPEN;
			}
			else
			{
				memcpy (Text, "Gate/Ref ", 9);
				memcpy (&Text[9], RefName, 7);
				memcpy (&Text[16], "not found in DDB", 16);
				xMessage.pcMessage = (char *)Text;
				xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
				xQueueSend( xLCDQueue, &xMessage, 0 );
				sprintf (text, "%19.19s Gateway/Reflector not found in ircDDB DNS (%7.7s)\r\n", TimeDate, RefName);
				xQueueSend( xDstarLogQueue, &text, 0 );
				NodeDPlusState = DS_WAIT_LINK_COMMAND;
			}
			break;

		case DS_UDP_OPEN:
			if (ReloadSW)
			{
				ReloadSW = FALSE;
				NodeDPlusState = DS_LOOP;
				break;
			}
			if (!AppConfig.Flags.ircDDB)
			{
				memcpy (REF_IP_address, RefName, 8);
				REF_IP_address[15] = 'S';
				while (REF_IP_address[15] == 'S') vTaskDelay(10 / portTICK_RATE_MS);
				if (REF_IP_address[0] == 0x00)
				{
					if (!RefName[0]) memset (RefName, 0x20, 8);
					memcpy (Text, "Gate/Ref ", 9);
					memcpy (&Text[9], RefName, 7);
					memcpy (&Text[16], "not found.      ", 16);
					xMessage.pcMessage = (char *)Text;
					xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
					xQueueSend( xLCDQueue, &xMessage, 0 );
					NodeDPlusState = DS_WAIT_LINK;
					sprintf (text, "%19.19s Gateway/Reflector not found (%7.7s)\r\n", TimeDate, RefName);
					xQueueSend( xDstarLogQueue, &text, 0 );
					memset (RefName, 0x20, 8);
					RefNameSet = 0;
					if (!AppConfig.Flags.RepeaterSW) Msg.notfoundSW = TRUE;
					break;
				}
				memcpy (CurServerName, REF_IP_address, 16);
			}
			UDPInit();
//			RcvDPlusSocket = INVALID_UDP_SOCKET;
//			DPlusSocket = INVALID_UDP_SOCKET;

			ServerPort = 20001;	/* Defualt */
			if (AppConfig.Flags.ircDDB)
			{
				if (AppConfig.ircDDBtype == 1) ServerPort = 30051;	/* DCS */
				else if (AppConfig.ircDDBtype == 2) ServerPort = 30001;	/* Dxtra */
			}
			
			ServerSocket = UDPOpenEx((DWORD)CurServerName,UDP_OPEN_ROM_HOST,0,ServerPort);
			if (ServerSocket == INVALID_UDP_SOCKET)
			{
				if (!RefName[0]) memset (RefName, 0x20, 8);
				memcpy (Text, "Gate/Ref ", 9);
				memcpy (&Text[9], RefName, 7);
				memcpy (&Text[16], "Server Down.    ", 16);
				xMessage.pcMessage = (char *)Text;
				xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
				xQueueSend( xLCDQueue, &xMessage, 0 );
				NodeDPlusState = DS_WAIT_LINK;
				sprintf (text, "%19.19s Gateway/Reflector Server Down. (%7.7s)\r\n", TimeDate, RefName);
				xQueueSend( xDstarLogQueue, &text, 0 );
				memset (RefName, 0x20, 8);
				RefNameSet = 0;
				break;
			}
			NodeDPlusState = DS_UDP_IS_OPENED;
			RW_RO_sw = TRUE;
			memcpy (Text, "Linking  ", 9);
			memcpy (&Text[9], RefName, 7);
			memcpy (&Text[16], CurServerName, 16);
			xMessage.pcMessage = (char *)Text;
			xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
			xQueueSend( xLCDQueue, &xMessage, 0 );
			Timer = TickGet();
			break;
			
		case DS_UDP_IS_OPENED:
			if(UDPIsOpened(ServerSocket) == TRUE)
			{
				NodeDPlusState = DS_UDP_USB_DONE;
			}
			else
			{
				if ((TickGet() - Timer) > DPLUS_OPEN_TIMEOUT)
				{
//					UDPClose(ServerSocket);
//					ServerSocket = INVALID_UDP_SOCKET;
					if (UDPOpenTimeOutCnt < 5)
					{
						NodeDPlusState = DS_UDP_OPEN;
						break;
					}
					UDPOpenTimeOutCnt++;		
					NodeDPlusState = DS_UDP_OPEN;
					memcpy (Text, "Not Link ", 9);
					memcpy (&Text[9], RefName, 7);
					memcpy (&Text[16], "Server Down.    ", 16);
					xMessage.pcMessage = (char *)Text;
					xMessage.xMinDisplayTime = 2000 /  portTICK_RATE_MS;
					xQueueSend( xLCDQueue, &xMessage, 0 );
					sprintf (text, "%19.19s Gateway/Reflector %7.7s did not link (Server Down) (IP:%s)\r\n",TimeDate, RefName, CurServerName);
					xQueueSend( xDstarLogQueue, &text, 0 );
					memset (RefName, 0x20, 8);
					memset (RefNameSave, 0x20, 8);
					RefNameSet = 0;
				}
			}
			break;

		case DS_UDP_USB_DONE:
			if (PicVer[0])
			{
				NodeDPlusState = DS_UDP_SEND;
				if (UDPIsGetReady(ServerSocket)) UDPDiscard();
				Timer = TickGet();
			}
			break;

		case DS_UDP_SEND:
			// Make certain the socket can be written to
			if (UDPIsPutReady(ServerSocket) < 5)
			{
				if ((TickGet() - Timer) > DPLUS_OPEN_TIMEOUT)
				{
					UDPClose(RcvDPlusSocket);
//					RcvDPlusSocket = INVALID_UDP_SOCKET;
					UDPClose(ServerSocket);
//					ServerSocket = INVALID_UDP_SOCKET;
					NodeDPlusState = DS_HOME;
					memcpy (Text, "Not Link ", 9);
					memcpy (&Text[9], RefName, 7);
					memcpy (&Text[16], "Server down.    ", 16);
					xMessage.pcMessage = (char *)Text;
					xMessage.xMinDisplayTime = 2000 /  portTICK_RATE_MS;
					xQueueSend( xLCDQueue, &xMessage, 0 );
					memset (RefName, 0x20, 8);
					memset (RefNameSave, 0x20, 8);
					RefNameSet = 0;
				}
				break;
			}		

			LED1_IO ^= 1;
			if (!AppConfig.Flags.ircDDB)
				UDPPutArray((BYTE*) &ReqConnect, 5);
			else if (AppConfig.ircDDBtype == 1)
			{
				memcpy (&DCS_ReqConnect, AppConfig.DefaultAuthCall, 8);
				for (i = 0 ; i < 8 ; i++)
				{
					if (DCS_ReqConnect[i] == 0x00) DCS_ReqConnect[i] = 0x20;
				}
				memcpy (&DCS_ReqConnect[8], "DX", 2);
				DCS_ReqConnect[10] = 0x00;
				memcpy (&DCS_ReqConnect[11], RefName, 6);
				memcpy (&DCS_ReqConnect[17], "  ", 2);
				while (UDPIsPutReady(ServerSocket) < 5)	StackTaskUDP();
				UDPPutArray((BYTE*) &DCS_ReqConnect, 19);
			}
			UDPFlush();
			NodeDPlusState = DS_UDP_RECV;		
			Timer = TickGet();
			break;

		case DS_UDP_RECV:
			len = UDPIsGetReady(ServerSocket);
			if(!len) 
			{
				if((TickGet() - Timer) > DPLUS_OPEN_TIMEOUT)
				{
					NodeDPlusState = DS_WAIT_LINK;
					ReloadSW = FALSE;
					RefNameSet = 0;
					memcpy (Text, "Not Link ", 9);
					memcpy (&Text[9], RefName, 7);
					memcpy (&Text[16], "Server Down.    ", 16);
					xMessage.pcMessage = (char *)Text;
					xMessage.xMinDisplayTime = 2000 /  portTICK_RATE_MS;
					xQueueSend( xLCDQueue, &xMessage, 0 );
					memset (RefName, 0x20, 8);
					memset (RefNameSave, 0x20, 8);
					RefNameSet = 0;
				}
				break;
			}
	
			// Validate packet size
			if (!AppConfig.Flags.ircDDB)
			{
				if(len == 5) 
				{
					UDPGetArray((BYTE*)RecvTemp, 5);
					if (!memcmp (RecvTemp, ReqConnect, 5))
					{
						NodeDPlusState = DS_UDP_SEND_CALL;
						memcpy (Text, "Linked to       ", 16);
						memcpy ((char *)&Text[16], (char *)RefName, 8);
						Text[24] = 0x00;
						xMessage.pcMessage = (char *)Text;
	 					xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
						xQueueSend( xLCDQueue, &xMessage, 0 );
					}
				} 
				else if ((len == 3) && !memcmp((char *)&pkt, (char *)Sync, 3))
				{
					KeepAliveSend();
					TimeOutCnt = 0;
				}
			}
			else if (AppConfig.ircDDBtype == 1)
			{
				if (len == 14)
				{
						UDPGetArray((BYTE*)&pkt, 14);
						if (!memcmp((char *)&pkt.B_header.B_ID, "ACK", 3))
						{
							NodeDPlusState = DS_LOOP;
							memcpy (Text, "Linked to       ", 16);
							memcpy ((char *)&Text[16], (char *)RefName, 8);
							Text[24] = 0x00;
							xMessage.pcMessage = (char *)Text;
	 						xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
							xQueueSend( xLCDQueue, &xMessage, 0 );
						}
				}
			}

			break;

		case DS_UDP_SEND_CALL:
			// Make certain the socket can be written to
			if (UDPIsPutReady(ServerSocket) > 28)
			{
				memcpy ((char *)&AuthCallString[4], (char *)AppConfig.DefaultAuthCall, 8);
				memcpy ((char *)&AuthCallString[12], (char *)AppConfig.DefaultAuthPin, 8);
				UDPPutArray((BYTE*) &AuthCallString, 28);
				UDPFlush();
				NodeDPlusState = DS_UDP_RECV_OK;		
				Timer = TickGet();
				sprintf (text, "%19.19s Sent Auth. Packet.\r\n",TimeDate);
				xQueueSend( xDstarLogQueue, &text, 0 );
			}	
			break;

		case DS_UDP_RECV_OK:
			if(UDPIsGetReady(ServerSocket)) 
			{
				// Get the response from server
				len = UDPGetArray((BYTE*)RecvTemp, 8);
			
				// Validate packet size
				if ((len == 8) && (!memcmp (RecvTemp, CallOK, 8) || !memcmp (RecvTemp, CallRO, 8)))
				{
					NodeDPlusState = DS_UDP_SUB_SOCKET_OPEN;
					memcpy (Text, "Link to         ", 16);
					memset (&Text[16], 0x20, 16);
					l = strlen((char *)RefName);
					if (l > 8) l = 8;
					memcpy (&Text[16], RefName, l);
					if (!memcmp (RecvTemp, CallOK, 8))
					{
						memcpy (&Text[30], "RW",2);
						RW_RO_sw = TRUE;
					}
					else
					{
						memcpy (&Text[30], "RO",2);
						RW_RO_sw = FALSE;
					}
					xMessage.pcMessage = (char *)Text;
		 			xMessage.xMinDisplayTime = 1000 /  portTICK_RATE_MS;
					xQueueSend( xLCDQueue, &xMessage, 0 );
					KeepAliveSend();
					TimeOutCnt = 0;
					sprintf (text, "%19.19s Linked to %8.8s(%2.2s)\r\n",TimeDate, RefName, &Text[30]);
					xQueueSend( xDstarLogQueue, &text, 0 );
					StillKeep = FALSE;
					ReConnectCnt = 0;
					if (!AppConfig.Flags.RepeaterSW) Msg.connectSW = TRUE;
				}
				else if ((len == 3) && !memcmp((char *)&pkt, (char *)Sync, 3))
				{
					KeepAliveSend();
				}
				else
				{
					if ((TickGet() - Timer) > 5*TICK_SECOND) NodeDPlusState = DS_UDP_SEND_CALL;
				}	
			} else {
				if ((TickGet() - Timer) > 5*TICK_SECOND) NodeDPlusState = DS_UDP_SEND_CALL;
			} 
			break;

		case DS_UDP_SUB_SOCKET_OPEN:
			if(!UDPIsOpened(RcvDPlusSocket))
				RcvDPlusSocket = UDPOpenEx((DWORD)NULL,UDP_OPEN_SERVER,ServerPort,0);
			NodeDPlusState = DS_LOOP;
			break;

 	}
}

void	KeepAliveSend( void )
{
	if (AppConfig.Flags.ircDDB) return;

	while (UDPIsPutReady(ServerSocket) < 3)	StackTaskUDP();
	UDPPutArray((BYTE*)Sync, 3);
	UDPFlush();
	LED1_IO ^= 1;
	KeepAliveTimer = TickGet();
}

void	add_connected_table (UDP_SOCKET sock, BYTE callsign[])
{
	static	struct	connected_table *pnt;

	pnt = pvPortMalloc (sizeof (struct connected_table));
	pnt->f_chain = NULL;
	pnt->SendSocket = sock;
	pnt->timeout = TickGet();
	memcpy (pnt->MyName, callsign, 8);
	last_pnt->f_chain = pnt;
	last_pnt = pnt;

	sprintf (text, "%19.19s Linked from Sub Client %8.8s\r\n",TimeDate, callsign);
	xQueueSend( xDstarLogQueue, &text, 0 );
}

void	delete_from_table (UDP_SOCKET sock)
{
	struct	connected_table *pnt, *pnt_wrk;

	pnt_wrk = first_pnt;
	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->SendSocket == sock)
		{
			sprintf (text, "%19.19s Deleted from Sub Client Table %8.8s\r\n",TimeDate, pnt->MyName);
			xQueueSend( xDstarLogQueue, &text, 0 );
			UDPClose(pnt->SendSocket);
			pnt_wrk->f_chain = pnt->f_chain;
			vPortFree (pnt);
			last_pnt = first_pnt;
			pnt = first_pnt->f_chain;
			while (pnt)
			{
				last_pnt = pnt;
				pnt = pnt->f_chain;
			}
			return;
		}
		pnt_wrk = pnt;
		pnt = pnt->f_chain;
	}
}

void	SendSubClient (packet pkt)
{
	static	struct	connected_table *pnt;

	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (!memcmp((char *)pkt.DPlusID, (char *)VoiceID, 2))
		{
			while (UDPIsPutReady(pnt->SendSocket) < 29) StackTaskUDP();
			UDPPutArray((BYTE*) &pkt, 29);	
			UDPFlush();
		}
		else if (!memcmp((char *)pkt.DPlusID, (char *)HeaderID, 2))
		{
			while (UDPIsPutReady(pnt->SendSocket) < 58) StackTaskUDP();
			UDPPutArray((BYTE*) &pkt, 58);	
			UDPFlush();
		}
		else if (!memcmp((char *)pkt.DPlusID, (char *)LastFrameID, 2))
		{
			while (UDPIsPutReady(pnt->SendSocket) < 32) StackTaskUDP();
			UDPPutArray((BYTE*) &pkt, 32);	
			UDPFlush();
		}
		else if (!memcmp((char *)pkt.DPlusID, (char *)PttOff, 2))
		{
			while (UDPIsPutReady(pnt->SendSocket) < 10) StackTaskUDP();
			UDPPutArray((BYTE*) &pkt, 10);	
			UDPFlush();
		}
		pnt = pnt->f_chain;
	}
}

void	SendFromSubClient(packet pkt, UDP_SOCKET socket)
{
	static	struct	connected_table *pnt;
	static	BYTE	SubRcvPacket_ID[2];

	/* send pakcet to rig from sub client */
	if (!Msg.connectSW)
	{
		if (!memcmp((char *)pkt.DPlusID, (char *)HeaderID, 2))
		{
			if (!memcmp((char *)&pkt.header[3], (char *)RefName, 8))
			{
				xQueueSend (xDstarRcvQueue, &pkt, 50 / portTICK_RATE_MS);
				memcpy (SubRcvPacket_ID, &pkt.B_header.PacketID, 2);
			} else { 
				memset ((char *)SubRcvPacket_ID, 0x00, 2);
			}	
		}
		else if (!memcmp(SubRcvPacket_ID, &pkt.B_header.PacketID, 2))
		{
			if (!memcmp((char *)pkt.DPlusID, (char *)VoiceID, 2))
			{
				xQueueSend (xDstarRcvQueue, &pkt, 50 / portTICK_RATE_MS);
			}
			else if (!memcmp((char *)pkt.DPlusID, (char *)LastFrameID, 2))
			{
				xQueueSend (xDstarRcvQueue, &pkt, 50 / portTICK_RATE_MS);
			}
			else if (!memcmp((char *)pkt.DPlusID, (char *)PttOff, 2))
			{
				xQueueSend (xDstarRcvQueue, &pkt, 50 / portTICK_RATE_MS);
			}
		}
	}

	/* send packet to DPlus from sub client */
	if (!memcmp((char *)pkt.DPlusID, (char *)VoiceID, 2))
	{
		while (UDPIsPutReady(ServerSocket) < 29) StackTaskUDP();
		UDPPutArray((BYTE*) &pkt, 29);	
		UDPFlush();
	}
	else if (!memcmp((char *)pkt.DPlusID, (char *)HeaderID, 2))
	{
		while (UDPIsPutReady(ServerSocket) < 58) StackTaskUDP();
		UDPPutArray((BYTE*) &pkt, 58);	
		UDPFlush();
	}
	else if (!memcmp((char *)pkt.DPlusID, (char *)LastFrameID, 2))
	{
		while (UDPIsPutReady(ServerSocket) < 32) StackTaskUDP();
		UDPPutArray((BYTE*) &pkt, 32);	
		UDPFlush();
	}
	else if (!memcmp((char *)pkt.DPlusID, (char *)PttOff, 2))
	{
		while (UDPIsPutReady(ServerSocket) < 10) StackTaskUDP();
		UDPPutArray((BYTE*) &pkt, 10);	
		UDPFlush();
	}
	LED1_IO ^= 1;

	/* send sub client from sub client */
	pnt = first_pnt->f_chain;
	while (pnt)
	{
		if (pnt->SendSocket != socket)
		{
			if (!memcmp((char *)pkt.DPlusID, (char *)VoiceID, 2))
			{
				while (UDPIsPutReady(pnt->SendSocket) < 29) StackTaskUDP();
				UDPPutArray((BYTE*) &pkt, 29);	
				UDPFlush();
			}
			else if (!memcmp((char *)pkt.DPlusID, (char *)HeaderID, 2))
			{
				while (UDPIsPutReady(pnt->SendSocket) < 58) StackTaskUDP();
				UDPPutArray((BYTE*) &pkt, 58);	
				UDPFlush();
			}
			else if (!memcmp((char *)pkt.DPlusID, (char *)LastFrameID, 2))
			{
				while (UDPIsPutReady(pnt->SendSocket) < 32) StackTaskUDP();
				UDPPutArray((BYTE*) &pkt, 32);	
				UDPFlush();
			}
			else if (!memcmp((char *)pkt.DPlusID, (char *)PttOff, 2))
			{
				while (UDPIsPutReady(pnt->SendSocket) < 10) StackTaskUDP();
				UDPPutArray((BYTE*) &pkt, 10);	
				UDPFlush();
			}
		}
		pnt = pnt->f_chain;
	}
}

void	ReLoadMsg()
{
	memcpy (Text, "ReLoad          " "   Gate/Ref List", 32);
	xMessage.pcMessage = (char *)Text;
	xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
	xQueueSend( xLCDQueue, &xMessage, 0 );
}

void	InetHeaderLog()
{
	sprintf (text, "%19.19s From Inet MyCall:%8.8s YourCall:%8.8s RPT1:%8.8s RPT2:%8.8s ID:%2.2x%2.2x\r\n",
			TimeDate,&pkt.header[27],&pkt.header[19],&pkt.header[11],&pkt.header[3],pkt.B_header.PacketID[0],pkt.B_header.PacketID[1]);
	xQueueSend( xDstarLogQueue, &text, 0 );
}

static	void	CallDisplay (BYTE RFheader[])
{
	static	xLCDMessage xMessage;
	extern	xQueueHandle xLCDQueue;
	static	ROM BYTE hex[16] = {"0123456789ABCDEF"};

	memset (&Text, 0x20, 32);
	memcpy (&Text[0],&RFheader[27], 8);
	memcpy (CurUser, &RFheader[27], 8);
	Text[14] = hex[RFheader[0]>>4];
	Text[15] = hex[RFheader[0] & 0x0f];
	memcpy (&Text[16],&RFheader[19], 8);
	if (memcmp (&RFheader[35],"    ",4))
	{
		Text[8] = '/';
		memcpy (&Text[9],&RFheader[35], 4);
	}
	memcpy (&Text[27], " Inet", 5);
	xMessage.pcMessage = (char *)&Text;
	xMessage.xMinDisplayTime = 1000 / portTICK_RATE_MS;
	xQueueSend( xLCDQueue, &xMessage, 0 );
	return;
}

static	BYTE	dprs_data[150];
static	BYTE	dprs_pnt = 0;

static	void	DprsData(BYTE Sdata[])
{
	static	BYTE	len;
		len = Sdata[0] &0x0f;
		if ((dprs_pnt + len) >= 120)
		{
			dprs_pnt = 0;
			return;
		} 
		memcpy (&dprs_data[dprs_pnt], &Sdata[1], len);
		dprs_pnt += len;
		if (dprs_data[dprs_pnt - 1] == 0x0d) dprs_data[dprs_pnt++] = 0x0a;
		if (dprs_data[dprs_pnt - 1] == 0x0a)
		{
			if (DebugSW) xQueueSend( xDstarLogQueue, &dprs_data, 0 );
			if (gps_sumcheck(dprs_data))
			{
					dprs_data[dprs_pnt - 1] = 0x00;
					if(!memcmp (dprs_data, "$GPGLL,", 7)) GPGLL (&dprs_data[7]);
					else if(!memcmp (dprs_data, "$GPGGA,", 7)) GPGGA (&dprs_data[7]);
					else if(!memcmp (dprs_data, "$GPRMC,", 7)) GPRMC (&dprs_data[7]);
					else if(!memcmp (dprs_data, "$$CRC", 5)) Inet_GPS_A (&dprs_data[10]);
					else if(dprs_data[0] != '$') dprs_message(dprs_data);
			}

			dprs_pnt = 0;
		} 
}


static	BOOL	gps_sumcheck(BYTE string[])
{
	BYTE	*pnt;
	static	BYTE	sum, csum, tmp;

	if (!memcmp (string, "$$CRC", 5))
	{
		return GPS_A_SumCheck(string);
	}
	pnt = string;
	sum = 0;
	if (*pnt == '$') pnt++;
	while (*pnt !='*')
	{
		if ((*pnt == 0x0a) || (*pnt == 0x0d)) return FALSE;
		sum ^= *pnt;
		pnt++;
	}
	pnt++;
	tmp = *pnt - '0';
	if (tmp > 16) tmp -= 7;
	csum = tmp << 4;
	pnt++;
	tmp = *pnt - '0';
	if (tmp > 16) tmp -= 7;
	csum += tmp;
	if (csum == sum) return TRUE;
	return FALSE;
}

static	void	GPGLL (BYTE string[])
{
	static	BYTE	*pnt;
	static	BYTE	i;

	pnt = string;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 7)
		{
			InetLat[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	RadioLat[7] = *pnt;
	pnt += 2;

	i = 0;
	while (*pnt != ',')
	{
		if (i < 8)
		{
			InetLong[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	InetLong[8] = *pnt;
}

static	void	GPGGA (BYTE string[])
{
	static	BYTE	*pnt;
	static	BYTE	i;
	static	DWORD	d;
	static	BYTE	tmp[10];
	static	WORD	k;

	pnt = string;
	while (*pnt != ',') pnt++;
	pnt++;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 7)
		{
			InetLat[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	InetLat[7] = *pnt;
	pnt += 2;

	i = 0;
	while (*pnt != ',')
	{
		if (i < 8)
		{
			InetLong[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	InetLong[8] = *pnt;

	pnt += 2;
	while (*pnt != ',') pnt++;
	pnt++;
	while (*pnt != ',') pnt++;
	pnt++;
	while (*pnt != ',') pnt++;
	pnt++;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 8)
		{
			tmp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	tmp[i] = 0x00;
	d = atof ((char *)tmp);
	k = d / 0.3048 + 0.5;
	sprintf ((char *)InetAtitude, "%06d", k); 
}

static	void	GPRMC (BYTE string[])
{
	static	DWORD	d;
	static	BYTE	tmp[10];
	static	WORD	k;
	static	BYTE	*pnt;
	static	BYTE	i;

	pnt = string;
	while (*pnt != ',') pnt++;
	pnt++;
	while (*pnt != ',') pnt++;
	pnt++;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 7)
		{
			InetLat[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	InetLat[7] = *pnt;
	pnt += 2;

	i = 0;
	while (*pnt != ',')
	{
		if (i < 8)
		{
			InetLong[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	InetLong[8] = *pnt;
	pnt += 2;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 9)
		{
			tmp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	tmp[i] = 0x00;
	d = atof ((char *)tmp);
	k = d + 0,5;
	sprintf ((char *)InetSpeed, "%03d", k);

	pnt++;
	i = 0;
	while (*pnt != ',')
	{
		if (i < 9)
		{
			tmp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	tmp[i] = 0x00;
	d = atof ((char *)tmp);
	k = d + 0,5;
	sprintf ((char *)InetDirection, "%03d", k);
}

static	void	dprs_message (BYTE string[])
{
	static	BYTE	*pnt;
	static	BYTE	i, k;
	static	BYTE	len;

//	len = strlen ((char *)&string);
//	if (len <= 9) return;

	pnt = string;
	i = 0;
	memset (InetCall, 0x20, 8);
	while (*pnt != ',')
	{
		if (*pnt == 0x00) return;
		if (i < 8)
		{
			InetCall[i] = *pnt;
			i++;
		}
		pnt++;
	}
	k = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (InetCall[i] != 0x20)
		{
			InetCall[k] = InetCall[i];
			k++;
		} else {
			if (InetCall[k-1] != '-')
			{
				InetCall[k] = '-';
				k++;
			}
		}
	}

	if (InetCall[k-1] == '-') InetCall[k-1] = 0x00;

	if (k < 7)
	{
		for (i = k ; i < 8 ; i++)
		{
			InetCall[k] = 0x00;
		}
	}

	memset (InetMsg, 0x00, 20);
	len = strlen ((char *)&string[9]);
	if (len == 0) return;
	memcpy (InetMsg, &string[9], len);
	InetDprsSend = TRUE;
}


/*
	CRC update routine
 */

static	WORD	update_crc_dstar( WORD crc, BYTE c )
{
    WORD tmp, short_c;

    short_c  = 0x00ff &  c;
	
    tmp = (crc & 0x00ff) ^ short_c;
    crc = (crc >> 8)  ^ crc_tabccitt[tmp];

    return crc;

}  /* update_crc_dstar */


/*
	CRC reslut routine
 */

static	WORD		result_crc_dstar(WORD crc)
{

    WORD tmp;

      crc = ~crc;
      tmp = crc;
      crc = (crc << 8) | (tmp >> 8 & 0xff);

    return crc;

}  /* result_crc_dstar */

static BOOL	GPS_A_SumCheck(BYTE string[])
{
	static	WORD	crc_dstar_ffff, k, k0, k1, k2, k3;
	static	BYTE	*pnt;
	
    crc_dstar_ffff = 0xffff;	/* nornal value 0xffff */
	pnt = string + 10;

	while (*pnt != 0x0a)
	{
		crc_dstar_ffff = update_crc_dstar( crc_dstar_ffff, *pnt);
		pnt++;
	}

	crc_dstar_ffff = result_crc_dstar(crc_dstar_ffff);

	k0 = string[5] - '0';
	if (k0 > 16) k0 -= 7;
	k1 = string[6] - '0';
	if (k1 > 16) k1 -= 7;
	k2 = string[7] - '0';
	if (k2 > 16) k2 -= 7;
	k3 = string[8] - '0';
	if (k3 > 16) k3 -= 7;
	k1 += k0 * 16;
	k3 += k2 * 16;
    k = k1 | (k3 << 8);

	if (k == crc_dstar_ffff) return TRUE;
	return	FALSE;
}

static	void	Inet_GPS_A (BYTE string[])
{
	memcpy (Inet_GPS_A_MSG, string, strlen((char *)string));
	Inet_GPS_A_Msg_send = TRUE;
}


static	void	InetDprs_Send()
{
	static	BYTE	id[9];
	static	BYTE	msg_len;
	static	WORD	l, n;

	if ((TickGet() - AprsInetTimer) <= 29*TICK_SECOND) return;

	if(TCPIsPutReady(DprsSocket) < 150u) return;
	k = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (DPRS.CallSign[i] != 0x20)
		{
			id[k] = DPRS.CallSign[i];
			k++;
		}
		else
		{
			if (k > 0)
			{
				if(id[k-1] != '-')
				{
					id[k] = '-';
					k++;
				}
			}
		}
	}
	id[k] = 0x00;
	msg_len = 4;
	while (InetMsg[msg_len] != '*') msg_len++;
	msg_len -= 4;

	n = 0;
	l = 9999;
	while (memcmp(aprs_symbol[n][1], "    ", 4))
	{
		if (!memcmp(aprs_symbol[n][1], InetMsg, 4))
		{
			l = n;
			break;
		}
		n++;
	}
	if (l == 9999) l = 29;	// car
	TCPPutArray (DprsSocket, InetCall, strlen((char *)InetCall));
	TCPPutArray (DprsSocket, (BYTE *)">APE32X,DSTAR*,qAR,",19);
	TCPPutArray (DprsSocket, id, k);
	if (msg_len) TCPPutArray (DprsSocket, (BYTE *)":=", 2);
	else TCPPutArray (DprsSocket, (BYTE *)":!", 2);
	TCPPutArray (DprsSocket, InetLat, 8);
	TCPPut (DprsSocket, aprs_symbol[l][0][0]);
	TCPPutArray (DprsSocket, InetLong, 9);
	TCPPut (DprsSocket, aprs_symbol[l][0][1]);
	if (RadioDirection[0] != 0x00)
		TCPPutArray (DprsSocket, InetDirection, 3);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000", 3);
	TCPPut (DprsSocket, '/');
	if (InetSpeed[0] != 0x00)
		TCPPutArray (DprsSocket, InetSpeed, 3);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000", 3);
	TCPPutArray (DprsSocket, (BYTE *)"/A=", 3);
	if (InetAtitude[0] != 0x00)
		TCPPutArray (DprsSocket, InetAtitude, 6);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000000", 6);
	msg_len = 4;
	while (InetMsg[msg_len] != '*') msg_len++;
	msg_len -= 4;
	if (msg_len > 0) TCPPutArray (DprsSocket, &InetMsg[4], msg_len);
	TCPPutArray (DprsSocket, (BYTE *)"\r\n", 2);

	InetDprsSend = FALSE;		
	memset (InetDirection, 0x00, 3);
	memset (InetSpeed, 0x00, 3);
	memset (InetAtitude, 0x00, 6);
	AprsInetTimer = TickGet();
}

static	void	RadioDprs_Send()
{
	static	BYTE	id[9];
	static	BYTE	msg_len;
	static	WORD	l, n;

	if ((TickGet() - AprsRadioTimer) <= 29*TICK_SECOND) return;

	if(TCPIsPutReady(DprsSocket) < 200u) return;
	k = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (DPRS.CallSign[i] != 0x20)
		{
			id[k] = DPRS.CallSign[i];
			k++;
		}
		else
		{
			if (k > 0)
			{
				if(id[k-1] != '-')
				{
					id[k] = '-';
					k++;
				}
			}
		}
	}
	id[k] = 0x00;
	msg_len = 4;
	while (RadioMsg[msg_len] != '*') msg_len++;
	msg_len -= 4;

	n = 0;
	l = 9999;
	while (memcmp(aprs_symbol[n][1], "    ", 4))
	{
		if (!memcmp(aprs_symbol[n][1], RadioMsg, 4))
		{
			l = n;
			break;
		}
		n++;
	}
	if (l == 9999) l = 29;	// car
	TCPPutArray (DprsSocket, RadioCall, strlen((char *)RadioCall));
	TCPPutArray (DprsSocket, (BYTE *)">APE32X,DSTAR*,qAR,",19);
	TCPPutArray (DprsSocket, id, k);
	if (msg_len) TCPPutArray (DprsSocket, (BYTE *)":=", 2);
	else TCPPutArray (DprsSocket, (BYTE *)":!", 2);
	TCPPutArray (DprsSocket, RadioLat, 8);
	TCPPut (DprsSocket, aprs_symbol[l][0][0]);
	TCPPutArray (DprsSocket, RadioLong, 9);
	TCPPut (DprsSocket, aprs_symbol[l][0][1]);
	if (RadioDirection[0] != 0x00)
		TCPPutArray (DprsSocket, RadioDirection, 3);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000", 3);
	TCPPut (DprsSocket, '/');
	if (RadioSpeed[0] != 0x00)
		TCPPutArray (DprsSocket, RadioSpeed, 3);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000", 3);
	TCPPutArray (DprsSocket, (BYTE *)"/A=", 3);
	if (RadioAtitude[0] != 0x00)
		TCPPutArray (DprsSocket, RadioAtitude, 6);
	else
		TCPPutArray (DprsSocket, (BYTE *)"000000", 6);
	msg_len = 4;
	while (RadioMsg[msg_len] != '*') msg_len++;
	msg_len -= 4;
	if (msg_len > 0) TCPPutArray (DprsSocket, &RadioMsg[4], msg_len);
	TCPPutArray (DprsSocket, (BYTE *)"\r\n", 2);

	RadioDprsSend = FALSE;		
	memset (RadioDirection, 0x00, 3);
	memset (RadioSpeed, 0x00, 3);
	memset (RadioAtitude, 0x00, 6);
	AprsRadioTimer = TickGet();
}

static	void	Radio_GPS_A_Send()
{
	if ((TickGet() - AprsRadioTimer) > 29*TICK_SECOND)
	{
		if(TCPIsPutReady(DprsSocket) < 120u) return;
		TCPPutArray (DprsSocket, Radio_GPS_A_MSG, strlen((char *)Radio_GPS_A_MSG));
		Radio_GPS_A_Msg_send = FALSE;
		AprsRadioTimer = TickGet();
	}
}

static	void	Inet_GPS_A_Send()
{
	if ((TickGet() - AprsInetTimer) > 58*TICK_SECOND)
	{
		if(TCPIsPutReady(DprsSocket) < 120u) return;
		TCPPutArray (DprsSocket, Inet_GPS_A_MSG, strlen((char *)Inet_GPS_A_MSG));
		Inet_GPS_A_Msg_send = FALSE;
		AprsInetTimer = TickGet();
	}
}

void	DprsProcess()
{
	if(TCPIsConnected(DprsSocket))
	{
		if (!Msg.connectSW && !Msg.notfoundSW)			/* check the still voice message sending? */
		{
			if (RadioDprsSend) RadioDprs_Send();
			if (Radio_GPS_A_Msg_send) Radio_GPS_A_Send();
			if (InetDprsSend) InetDprs_Send();
			if (Inet_GPS_A_Msg_send) Inet_GPS_A_Send();
		}
		if (TCPIsGetReady(DprsSocket)) GetDprsMessage();
	}
	else
	{
		TCPClose (DprsSocket);
		DprsSocket = INVALID_SOCKET;
		Radio_GPS_A_Msg_send = FALSE;
		Inet_GPS_A_Msg_send = FALSE;
		DprsOpen = FALSE;
		sprintf (text, "%19.19s APRS server unlined\n",	TimeDate);
		xQueueSend( xDstarLogQueue, &text, 0 );
		if (DPRS.AutoReLink)
		{
			RefNameSet = 6;
			ReDprsConnectCnt = 0;
			ReDprsConnectCount = 0;
			sprintf (text, "%19.19s APRS server Auto, relink start\n",	TimeDate);
			xQueueSend( xDstarLogQueue, &text, 0 );
		}
	}
}

static	void	DprsBeacon_Send()
{
	static	BYTE	id[9];
	static	BYTE	msg_len;
	static	long int i;

	if(TCPIsPutReady(DprsSocket) < 70u) return;

	i = labs(DPRS.Lat) % 10000;
	i = i * 6 + 5;
	i /= 10;
	sprintf ((char *)RadioLat, "%02ld%02ld.%02ld" ,labs(DPRS.Lat)/10000, i/100, i%100);
	if (DPRS.Lat >= 0) RadioLat[7] = 'N';
	else RadioLat[7] = 'S';

	i = labs(DPRS.Long) % 10000;
	i = i * 6 + 5;
	i /= 10;
	sprintf ((char *)RadioLong, "%03ld%02ld.%02ld",labs(DPRS.Long)/10000, i/100, i%100);
	if (DPRS.Long >= 0) RadioLong[8] = 'E';
	else RadioLong[8] = 'W';
    
	k = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (DPRS.CallSign[i] != 0x20)
		{
			id[k] = DPRS.CallSign[i];
			k++;
		}
		else
		{
			if (k > 0)
			{
				if(id[k-1] != '-')
				{
					id[k] = '-';
					k++;
				}
			}
		}
	}
	id[k] = 0x00;

	msg_len = strlen((char *)DPRS.Comment);
	if (msg_len > 20) msg_len = 20;
	TCPPutArray (DprsSocket, id, k);
	TCPPutArray (DprsSocket, (BYTE *)">APE32X,TCPIP*,qAC,",19);
	TCPPutArray (DprsSocket, id, k);
	TCPPutArray (DprsSocket, (BYTE *)":=", 2);
	TCPPutArray (DprsSocket, RadioLat, 8);
	TCPPut (DprsSocket, 'D');
	TCPPutArray (DprsSocket, RadioLong, 9);
	TCPPut (DprsSocket, '&');
	if (msg_len > 0) TCPPutArray (DprsSocket, DPRS.Comment, msg_len);
	TCPPutArray (DprsSocket, (BYTE *)"\r\n", 2);
	DprsBeaconTimer = TickGet();
}

static	void	GetDprsMessage()
{
	static	char 	*msg, *msge, *msgstart, *msgend, *dstpnt, *msglast;
	static	WORD	len, k1;
	static	BYTE	id[10];
	static	struct	AprsCallTable	*NextTable;

	len = TCPGetArray(DprsSocket, DprsTemp, 500);
	if (len == 0) return;

	if (Msg.connectSW || Msg.notfoundSW || ReqLoadAprsCallCheck) return;

	msgstart = (char *)&DprsTemp;	
	msglast = msgstart + len - 1;
	DprsTemp[len++] = 0x00;
	DprsTemp[len] = 0x00;
	
	dstpnt = strstr(msgstart, "::");
skip:
	if (!dstpnt) return;
	if (*(dstpnt-1) == '`')
	{
		dstpnt = strstr(dstpnt+2, "::");
		goto skip;
	}

next:
	if (msgstart >= msglast) return;
	msgend = strstr (msgstart, "\r\n");	
	if (!msgend) return;
	if (msgend < dstpnt)
	{
		msgstart = msgend + 2;
		goto next;
	}
	*msgend = 0x00;

	if (dstpnt+11 > msgend)
	{
		msgstart = msgend + 2;
		goto next;
	}		
	if (*(dstpnt+11) != ':')
	{
		msgstart = msgend + 2;
		goto next;
	}		

	msg = strstr (msgstart, "qAC");
	if (!msg) msg = strstr (msgstart, "qAS");
	if (!msg) msg = strstr (msgstart, "qAR");
	if (!msg) return;
	if (!memcmp(msg+4, "AE5PL-JF", 8)) return;
	if (*(dstpnt+12) == 0x00) return;

	if ((dstpnt+14) <= msgend)
	{
		memset (id, 0x20, 9);
		if (strstr(dstpnt+12, "ack"))
		{
			if (memcmp(dstpnt+2, AprsSenderCall, strlen((char *)AprsSenderCall))) return;		/* skip ack message */
			RcvAprsSeq = atol (dstpnt+15);
			return; 			
		}
	}		

	msge = strchr (msgstart, '>');
	if (!msge) return;
	k1 = msge - msgstart;	/* skip space */
	if (!k1) return;
	memcpy (DprsMsgDstCallSign, dstpnt+2, 9);
	NextTable = AprsCallTablePnt;
	while  (NextTable)
	{
		if (NextTable->CallLength == 0) goto Find;
		if (!memcmp (&DprsMsgDstCallSign, NextTable->CallSign, NextTable->CallLength)) goto Find;
		NextTable = NextTable->Next;
	}
	return;

Find:
	if (memcmp(DprsMsgDstCallSignSave, DprsMsgDstCallSign, 9))
	{
		DprsMsgDstCallSign[9] = 'S';		/* check Destination call */
		while (DprsMsgDstCallSign[9] == 'S') vTaskDelay(5 / portTICK_RATE_MS);
		if (DprsMsgDstCallSign[9] == 'N') return;	/* not found */
		memcpy (DprsMsgDstCallSignSave, DprsMsgDstCallSign, 9);
	} 

	memset (DprsMsgSrcCallSign, 0x20, 9);
	memcpy (DprsMsgSrcCallSign, msgstart, k1);

	DprsMsgSend((BYTE *)dstpnt+12);

	msg = strchr (dstpnt+12, '{');
	if (!msg) return;

	msg++;
	msge = msg;
	if (msge >= msgend) return;
	while (*msge != 0x00)
	{
		if (msge >= msgend) break;
		msge++;
	}
	if (msg == msge) return;
	*msge = 0x00;
	if ((msge - msg) <= 5)  DprsAck((BYTE *)msg); 
}

static	void	AprsMsgSend()
{
	extern	BYTE	AprsSenderCall[10];
	static	BYTE	seqID[8];
	static	BYTE	k;

	if(TCPIsPutReady(DprsSocket) < 200u) return;

	AprsMessageSend = FALSE;

	for (i = 0 ; i < 9 ; i++)
	{
		if (AprsDest[i] <= 0x20) AprsDest[i] = 0x00;
	}
	if (AprsDest[0] == 0x00) return;

	if (!strlen((char *)AprsMessage))return;

	TCPPutArray (DprsSocket, AprsSenderCall, strlen((char *)AprsSenderCall));
	TCPPutArray (DprsSocket, (BYTE *)">APE32X,TCPIP*",14);
	TCPPutArray (DprsSocket, (BYTE *)"::",2);
	k = strlen ((char *)AprsDest);
	if (k > 9) k = 9;
	TCPPutArray (DprsSocket, AprsDest, k);
	k = 9 - k;
	if (k) TCPPutArray (DprsSocket, (BYTE *)"         ", k);
	TCPPut (DprsSocket, ':');
	TCPPutArray (DprsSocket, AprsMessage, strlen((char *)AprsMessage));
	TCPPut (DprsSocket, '{');
	sprintf ((char *)seqID, "%-ld", AprsSeq);
	TCPPutArray (DprsSocket, seqID, strlen((char *)seqID));
	TCPPutArray (DprsSocket, (BYTE *)"\r\n", 2);
}

static	void	DprsMsgSend(BYTE Msg[])
{
	static	BYTE	tmp[138];
	static	WORD	len, i, k, j;

	memset (tmp, 0x20, 40);
	memcpy (tmp, DprsMsgSrcCallSign, 9);
	memcpy (&tmp[10], DprsMsgDstCallSign, 9);
	len = strlen ((char *)Msg);
	if (!len) return;
	k = 0;
	for (i = 0 ; i < len ; i++)
	{
		if ((Msg[i] == '{') || (Msg[i] == 0x00)) break;
		k++;			 	
	}
	if (k == 0) return;
	if (k > 67) k = 67;
	j = k;
	if (j > 20) j = 20;
	if (j > 0)
	{
		memcpy (&tmp[20], Msg, j);
		if (!memcmp (AprsMsgTX, "ON" , 2)) xQueueSend( xDstarDprsMsgQueue, tmp, 0 );
	}
	
	if (EmailAddress[0] != 0x00)
	{
		memset (tmp, 0x00, 138);
		memcpy (&tmp, DprsMsgSrcCallSign, 9);
		memcpy (&tmp[10], DprsMsgDstCallSign, 9);
		memcpy (&tmp[20], Msg, k);
		memcpy (&tmp[90], EmailAddress, 48);
		xQueueSend( xDstarDprsEmailMsgQueue, tmp, 0 );
	}
}

static	void	DprsAck(BYTE SeqID[])
{
	static	BYTE	PathID[9];
	static	long int i, kk;

	if(TCPIsPutReady(DprsSocket) < 70u) return;

	kk = 0;
	for (i = 0 ; i < 9 ; i++)
	{
		if (DprsMsgDstCallSign[i] != 0x20) kk++;
	}

	TCPPutArray (DprsSocket, DprsMsgDstCallSign, kk);
	TCPPutArray (DprsSocket, (BYTE *)">APE32X,TCPIP*,qAC,",19);

	kk = 0;
	for (i = 0 ; i < 8 ; i++)
	{
		if (DPRS.CallSign[i] != 0x20)
		{
			PathID[kk] = DPRS.CallSign[i];
			kk++;
		}
		else
		{
			if (kk > 0)
			{
				if(PathID[kk-1] != '-')
				{
					PathID[kk] = '-';
					kk++;
				}
			}
		}
	}
	PathID[kk] = 0x00;

	TCPPutArray (DprsSocket, PathID, kk);
	TCPPutArray (DprsSocket, (BYTE *)"::", 2);
	TCPPutArray (DprsSocket, DprsMsgSrcCallSign, 9);
	TCPPutArray (DprsSocket, (BYTE *)":ack", 4);
	i = strlen ((char *)SeqID);
	TCPPutArray (DprsSocket, SeqID, i);
	TCPPutArray (DprsSocket, (BYTE *)"\r\n", 2);
}


static	void	RefSolved(void)
{
	static	IP_ADDR	ServerIP;

	switch(RefSolveState)
	{
		case REFSOLVE_HOME:
			// Obtain ownership of the DNS resolution module
			if(!DNSBeginUsage()) break;

			DNSResolve(RefDomainName, DNS_TYPE_A);
			
			DnsTimer = TickGet();
			RefSolveState++;
			break;

		case REFSOLVE_NAME_RESOLVE:
			// Wait for the DNS server to return the requested IP address
			if(!DNSIsResolved(&ServerIP))
			{
				// Timeout after 6 seconds of unsuccessful DNS resolution
				if(TickGet() - DnsTimer > 12*TICK_SECOND)
				{
					RefSolveState = REFSOLVE_HOME;
					DNSEndUsage();
				}
				break;
			}

			// Release the DNS module, we no longer need it
			if(!DNSEndUsage())
			{
				// An invalid IP address was returned from the DNS 
				// server.  Quit and fail permanantly if host is not valid.
				RefSolveState++;
				ServerIP.Val = 0;
				break;
			}

			RefSolveState++;
			// No need to break here

		case REFSOLVE_OBTAIN:
			memset (RefDomainName, 0x00, 20);
			sprintf ((char *)RefDomainName, "%-d.%-d.%-d.%-d",ServerIP.v[0], ServerIP.v[1], ServerIP.v[2], ServerIP.v[3]);
			RefSolveState = REFSOLVE_HOME;
			ReqRefDomainName = FALSE;
			break;			
	}
}
